#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.BOL.UnitTests
{

	
	

	[TestFixture]
	public class BOL_RackTest : BaseTest 
	{

		private System.Guid _reagentGuid;
		private System.Guid _rackGuid;

		private DataTable _dtRackTest;
		private DataTable _dtRackLot;
		
		private BOL.RackTest _tstRT;

		[SetUp]
		protected void SetUp()
		{
			this.BaseSetUp();

			if (this.RefreshData)
			{
				this._dtRackLot = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM RackLot WHERE ReagentGuid IS NOT NULL AND RackLotGuid IN (SELECT RackLotGuid FROM RackTest WHERE RecordStatusCode = 'A') AND RackGuid IS NOT NULL AND RecordStatusCode = 'A' AND DivisionCode = '" + UnitTestConfig.TestDivisionCode + "'", true);
				this._dtRackTest = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM RackTest WHERE RackLotGuid = '" + this._dtRackLot.Rows[0][TABLES.RackLot.RackLotGuid].ToString() + "'", true);

				this._reagentGuid = (System.Guid)this._dtRackLot.Rows[0][TABLES.RackLot.ReagentGuid];
				this._rackGuid = (System.Guid)this._dtRackLot.Rows[0][TABLES.RackLot.RackGuid];

				this.RefreshData = false;
			}

			this._tstRT = new BOL.RackTest(this._dtRackTest.Rows[0]);
		}

		[Test]
		public void Ctor_Pass()
		{
			BOL.RackTest tmpRT = new BOL.RackTest();

			Assert.IsNotNull(tmpRT);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Ctor_Fail()
		{
		}

		[Test]
		public void Ctor_DataRow_Pass()
		{
			BOL.RackTest tmpRT = new BOL.RackTest(this._dtRackTest.Rows[0]);

			Assert.IsNotNull(tmpRT);
			Assert.IsTrue(tmpRT.RackTestGuid == (System.Guid)this._dtRackTest.Rows[0][TABLES.RackTest.RackTestGuid]);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Ctor_DataRow_Fail()
		{
		}

		
		[Test]
		public void RackTestGuid_Pass()
		{
			System.Guid tstValue = System.Guid.NewGuid();

			this._tstRT.RackTestGuid = tstValue;

			Assert.IsTrue(this._tstRT.RackTestGuid == tstValue);
		}

		
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void RackTestGuid_Fail()
		{
		}

		
		[Test]
		public void TestDate_Pass()
		{
			System.DateTime tstValue = System.DateTime.Now;

			this._tstRT.TestDate = tstValue;

			Assert.IsTrue(this._tstRT.TestDate == tstValue);
		}

		
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void TestDate_Fail()
		{
		}

		[Test]
		public void RackTestResult_Pass()
		{
			string tstValue = System.DateTime.Now.ToString();

			this._tstRT.RackTestResult = tstValue;

			Assert.IsTrue(this._tstRT.RackTestResult == tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void RackTestResult_Fail()
		{
		}

		[Test]
		public void RackTestResultTypeCode_Pass()
		{
			string tstValue = System.DateTime.Now.ToString();

			this._tstRT.RackTestResultTypeCode = tstValue;

			Assert.IsTrue(this._tstRT.RackTestResultTypeCode == tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void RackTestResultTypeCode_Fail()
		{
		}

		[Test]
		public void ReagentAmount_Pass()
		{
			int tstValue = new Random().Next(1,99999);

			this._tstRT.ReagentAmount = tstValue;

			Assert.IsTrue(this._tstRT.ReagentAmount == tstValue);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void ReagentAmount_Fail()
		{
		}

		[Test]
		public void GetRackTestResult_Pass()
		{
			DataTable dtTest = RackTest.GetRackTestResult(this._reagentGuid, this._rackGuid, Guid.Empty);
			Assert.IsTrue(dtTest.Rows.Count >= 0);
		}

		[Test]
		public void GetRackTestResult_Fail()
		{
			DataTable dtTest = RackTest.GetRackTestResult(Guid.NewGuid(), Guid.NewGuid(), Guid.Empty);
			Assert.IsTrue(dtTest.Rows.Count == 0);
		}

		[Test]
		public void GetPreviousRackTestResult_Pass()
		{
			string resultTypeCode = (this._dtRackTest.Rows[0].IsNull(TABLES.RackTest.RackTestResultTypeCode)) ? string.Empty : this._dtRackTest.Rows[0][TABLES.RackTest.RackTestResultTypeCode].ToString();
			int testWithId = (this._dtRackLot.Rows[0].IsNull(TABLES.RackLot.TestWithId)) ? 1 : (int)this._dtRackLot.Rows[0][TABLES.RackLot.TestWithId];
			string testWithName = (this._dtRackLot.Rows[0].IsNull(TABLES.RackLot.TestWithName)) ? "" : this._dtRackLot.Rows[0][TABLES.RackLot.TestWithName].ToString();

			string tstValue = BOL.RackTest.GetPreviousRackTestResult(this._reagentGuid, this._rackGuid, testWithId, testWithName, resultTypeCode, BOL.VBECSDateTime.GetDivisionCurrentDateTime());
			Assert.IsTrue(tstValue.Length >= 0);
		}

		[Test]
		public void GetPreviousRackTestResult_Fail()
		{
			string tstValue = RackTest.GetPreviousRackTestResult(Guid.NewGuid(), Guid.NewGuid(), 0, "", ARTIFICIAL.IS, System.DateTime.Now.AddYears(10));
			Assert.IsTrue(tstValue == string.Empty);
		}

		[Test]
		public void InactivateRackTestResults_Pass()
		{
			Guid dailyQcWorklistGuid = Guid.NewGuid();
			string insertDailyQc = "INSERT INTO DAILYQCWORKLIST (";
			insertDailyQc += TABLES.DailyQcWorklist.DailyQcWorklistGuid + ",";
			insertDailyQc += TABLES.DailyQcWorklist.DailyQcExpirationDate + ",";
			insertDailyQc += TABLES.DailyQcWorklist.RackGuid + ",";
			insertDailyQc += TABLES.DailyQcWorklist.DailyUseIndicator + ",";
			insertDailyQc += TABLES.DailyQcWorklist.PartiallyTestedIndicator + ",";
			insertDailyQc += TABLES.PatientSpecimen.DivisionCode + ",";
			insertDailyQc += TABLES.Reagent.RecordStatusCode + ",";
			insertDailyQc += TABLES.PatientSpecimen.LastUpdateDate + ",";
			insertDailyQc += TABLES.PatientSpecimen.LastUpdateUser + ",";
			insertDailyQc += TABLES.PatientSpecimen.LastUpdateFunctionId + ")";
			insertDailyQc += "VALUES (";
			insertDailyQc += "'" + dailyQcWorklistGuid.ToString() + "',";
			insertDailyQc += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now.AddDays(4)) + "',";
			insertDailyQc += "'" + this._rackGuid.ToString() + "',";
			insertDailyQc += "'1',";
			insertDailyQc += "'1',";
			insertDailyQc += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertDailyQc += "'A',";
			insertDailyQc += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertDailyQc += "'UnitTestUser',";
			insertDailyQc += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";
			//

			Guid reagentGuid = Guid.NewGuid();
			string insertReagent = "INSERT INTO REAGENT (";
			insertReagent += TABLES.Reagent.ReagentGuid + ",";
			insertReagent += TABLES.Reagent.ReagentTypeId + ",";
			insertReagent += TABLES.Reagent.ReagentName + ",";
			insertReagent += TABLES.Reagent.LotNumber + ",";
			insertReagent += TABLES.PatientSpecimen.DivisionCode + ",";
			insertReagent += TABLES.Reagent.RecordStatusCode + ",";
			insertReagent += TABLES.PatientSpecimen.LastUpdateDate + ",";
			insertReagent += TABLES.PatientSpecimen.LastUpdateUser + ",";
			insertReagent += TABLES.PatientSpecimen.LastUpdateFunctionId + ")";
			insertReagent += "VALUES (";
			insertReagent += "'" + reagentGuid.ToString() + "',";
			insertReagent += "'1',";
			insertReagent += "'TestReagent',";
			insertReagent += "'53000',";
			insertReagent += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertReagent += "'A',";
			insertReagent += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertReagent += "'UnitTestUser',";
			insertReagent += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			DateTime lotUseDate = DateTime.UtcNow;
		
			Guid rackLotGuid = Guid.NewGuid();
			string insertRackLot = "INSERT INTO RACKLOT (";
			insertRackLot += TABLES.RackLot.RackLotGuid + ",";
			insertRackLot += TABLES.RackLot.ReagentGuid + ",";
			insertRackLot += TABLES.RackLot.DailyQcWorklistGuid + ",";
			insertRackLot += TABLES.RackLot.LotUseDate + ",";
			insertRackLot += TABLES.PatientSpecimen.DivisionCode + ",";
			insertRackLot += TABLES.Reagent.RecordStatusCode + ",";
			insertRackLot += TABLES.PatientSpecimen.LastUpdateDate + ",";
			insertRackLot += TABLES.PatientSpecimen.LastUpdateUser + ",";
			insertRackLot += TABLES.PatientSpecimen.LastUpdateFunctionId + ")";
			insertRackLot += "VALUES (";
			insertRackLot += "'" + rackLotGuid.ToString() + "',";
			insertRackLot += "'" + reagentGuid.ToString() + "',";
			insertRackLot += "'" + dailyQcWorklistGuid.ToString() + "',";
			insertRackLot += "'" + Common.VBECSDateTime.FormatDateTimeString(lotUseDate) + "',";
			insertRackLot += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertRackLot += "'A',";
			insertRackLot += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertRackLot += "'UnitTestUser',";
			insertRackLot += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";
			
			Guid rackTestGuid = Guid.NewGuid();
			string insertRackTest = "INSERT INTO RACKTEST (";
			insertRackTest += TABLES.RackTest.RackTestGuid + ",";
			insertRackTest += TABLES.RackTest.RackLotGuid + ",";
			insertRackTest += TABLES.RackTest.TestDate + ",";
			insertRackTest += TABLES.RackTest.RackTestResultTypeCode + ",";
			insertRackTest += TABLES.PatientSpecimen.DivisionCode + ",";
			insertRackTest += TABLES.Reagent.RecordStatusCode + ",";
			insertRackTest += TABLES.PatientSpecimen.LastUpdateDate + ",";
			insertRackTest += TABLES.PatientSpecimen.LastUpdateUser + ",";
			insertRackTest += TABLES.PatientSpecimen.LastUpdateFunctionId + ")";
			insertRackTest += "VALUES (";
			insertRackTest += "'" + rackTestGuid.ToString() + "',";
			insertRackTest += "'" + rackLotGuid.ToString() + "',";
			insertRackTest += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertRackTest += "'CC',";
			insertRackTest += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertRackTest += "'A',";
			insertRackTest += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertRackTest += "'UnitTestUser',";
			insertRackTest += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			UnitTestUtil.RunSQL(insertDailyQc);
			UnitTestUtil.RunSQL(insertReagent);
			UnitTestUtil.RunSQL(insertRackLot);
			UnitTestUtil.RunSQL(insertRackTest);

			bool tstValue = false;

			tstValue = RackTest.InactivateRackTestResults(this._rackGuid, new DataTable(), new DataTable(), Common.UpdateFunction.UnitTests);
			Assert.IsTrue(tstValue == true);
		}

		[Test]
		public void InactivateRackTestResults_Fail()
		{
			bool tstValue = RackTest.InactivateRackTestResults(Guid.Empty, new DataTable(), new DataTable(), Common.UpdateFunction.UnitTests);
			Assert.IsTrue(tstValue);
		}

		[Test]
		public void GetReagentTestResult_String_Guid_Pass()
		{
			DataTable dtTest = BOL.RackTest.GetReagentTestResult(UnitTestConfig.TestDivisionCode, this._reagentGuid);

			Assert.IsTrue(dtTest.Rows.Count >= 0);
		}
		
		[Test]
		public void GetReagentTestResult_String_Guid_Fail()
		{
			DataTable dtTest = BOL.RackTest.GetReagentTestResult("12345", System.Guid.NewGuid());

			Assert.IsTrue(dtTest.Rows.Count == 0);
		}

		[Test]
		public void GetReagentTestResult_String_Guid_Date_Pass()
		{
			DataTable dtTest = BOL.RackTest.GetReagentTestResult(UnitTestConfig.TestDivisionCode, this._reagentGuid, this._tstRT.TestDate);

			Assert.IsTrue(dtTest.Rows.Count >= 0);
		}
		
		[Test]
		public void GetReagentTestResult_String_Guid_Date_Fail()
		{
			DataTable dtTest = BOL.RackTest.GetReagentTestResult("12345", System.Guid.NewGuid(), System.DateTime.Now);

			Assert.IsTrue(dtTest.Rows.Count == 0);
		}

		[Test]
		public void GetReagentTestResult_String_Guid_Date_String_Pass()
		{
			//char phaseCode = (this._dtRackLot.Rows[0].IsNull(TABLES.RackLot.ReactivityPhaseCode)) ? ' ' : (char)this._dtRackLot.Rows[0][TABLES.RackLot.ReactivityPhaseCode];

			char phaseCode = ' ';
			DataTable dtTest = BOL.RackTest.GetReagentTestResult(UnitTestConfig.TestDivisionCode, this._reagentGuid, this._tstRT.TestDate, phaseCode);

			Assert.IsTrue(dtTest.Rows.Count >= 0);
		}
		
		[Test]
		public void GetReagentTestResult_String_Guid_Date_String_Fail()
		{
			//char phaseCode = (this._dtRackLot.Rows[0].IsNull(TABLES.RackLot.ReactivityPhaseCode)) ? ' ' : (char)this._dtRackLot.Rows[0][TABLES.RackLot.ReactivityPhaseCode];
			char phaseCode = ' ';
			DataTable dtTest = BOL.RackTest.GetReagentTestResult("12345", System.Guid.NewGuid(), System.DateTime.Now, phaseCode);

			Assert.IsTrue(dtTest.Rows.Count == 0);
		}


		[Test]
		public void LoadDataRowFromThis_Pass()
		{
			DataRow drTest = this._tstRT.LoadDataRowFromThis(this._dtRackTest.NewRow());

			Assert.IsNotNull(drTest);
			Assert.IsTrue(drTest[TABLES.RackTest.RackTestGuid].ToString() == this._tstRT.RackTestGuid.ToString());
		}

		[Test]
		[ExpectedExceptionAttribute(typeof(BusinessObjectException))]
		public void LoadDataRowFromThis_Fail()
		{
			this._tstRT.LoadDataRowFromThis(new DataTable().NewRow());
		}

		[Test]
		public void VerifyMinColumnsInDataTable_Pass()
		{
			bool tstValue = this._tstRT.VerifyMinColumnsInDataTable( BOL.RackTest.RACKTESTCOLUMNS.Split(','), this._dtRackTest);
			Assert.IsTrue(tstValue);
		}

		[Test]
		public void VerifyMinColumnsInDataTable_Fail()
		{
			bool tstValue = this._tstRT.VerifyMinColumnsInDataTable( BOL.RackTest.RACKTESTCOLUMNS.Split(','), new DataTable());
			Assert.IsTrue(tstValue == false);
		}

		[Test]
		public void GetRackTestTableSchema_Pass()
		{
			DataTable dtTest = BOL.RackTest.GetRackTestTableSchema(true);
			Assert.AreEqual(8, dtTest.Columns.Count);
			
			DataTable dtTest2 = BOL.RackTest.GetRackTestTableSchema(false);
			Assert.AreEqual(7, dtTest2.Columns.Count);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetRackTestTableSchema_Fail()
		{
		}

	}
}
#endif



